<?php

/**
 * @file
 * Contains \Drupal\yamlform\Plugin\YamlFormElement\YamlFormContact.
 */

namespace Drupal\yamlform\Plugin\YamlFormElement;

use Drupal\Core\Form\FormState;
use Drupal\yamlform\Element\YamlFormContact as YamlFormContactElement;

/**
 * Provides a 'contact' element.
 *
 * @YamlFormElement(
 *   id = "yamlform_contact",
 *   label = @Translation("Contact"),
 *   category = @Translation("Composite"),
 *   multiline = TRUE,
 *   multiple = TRUE,
 *   composite = TRUE,
 * )
 */
class YamlFormContact extends YamlFormAddress {

  /**
   * {@inheritdoc}
   */
  protected function getCompositeElements() {
    return YamlFormContactElement::getCompositeElements();
  }

  /**
   * {@inheritdoc}
   */
  protected function getInitializedCompositeElement(array &$element) {
    $form_state = new FormState();
    $form_completed = [];
    return \Drupal\yamlform\Element\YamlFormContact::processYamlFormComposite($element, $form_state, $form_completed);
  }

  /**
   * {@inheritdoc}
   */
  protected function formatLines(array $element, array $value) {
    $lines = [];
    if (!empty($value['name'])) {
      $lines['name'] = $value['name'];
    }
    if (!empty($value['company'])) {
      $lines['company'] = $value['company'];
    }
    $lines += parent::formatLines($element, $value);
    if (!empty($value['email'])) {
      $lines['email'] = $value['email'];
    }
    if (!empty($value['phone'])) {
      $lines['phone'] = $value['phone'];
    }
    return $lines;
  }

}
