<?php

/**
 * @file
 * Contains \Drupal\yamlform\YamlFormOptionsAccessControlHandler.
 */

namespace Drupal\yamlform;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the YAML form options entity type.
 *
 * @see \Drupal\yamlform\Entity\YamlFormOptions.
 */
class YamlFormOptionsAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  public function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    return AccessResult::allowedIf($account->hasPermission('administer yamlform'))->cachePerPermissions();
  }

}
