<?php
return array(
    'controllers' => array(
        'factories' => array(
            'Operatore\Controller\Dashboard' => 'Operatore\Factory\DashboardControllerFactory',
            'Operatore\Controller\Ajax' => 'Operatore\Factory\AjaxControllerFactory',
        ),
    ),
    'router' => array(
        'routes' => array(

            'operatore' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/operatore',
                    'defaults' => array(
                        'controller' => 'Operatore\Controller\Dashboard',
                        'action' => 'index'
                    )
                )
            ),

            'ajax_refresh_display_operatore' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/ajax/refresh-display-operatore',
                    'defaults' => array(
                        'controller' => 'Operatore\Controller\Ajax',
                        'action' => 'refresh-display-operatore'
                    )
                )
            ),

            'ajax_avanti_operatore' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/ajax/avanti-operatore',
                    'defaults' => array(
                        'controller' => 'Operatore\Controller\Ajax',
                        'action' => 'avanti-operatore'
                    )
                )
            ),

            'ajax_chiama_operatore' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/ajax/chiama-operatore',
                    'defaults' => array(
                        'controller' => 'Operatore\Controller\Ajax',
                        'action' => 'chiama-operatore'
                    )
                )
            ),


        ),
    ),
    'view_manager' => array(
        'template_path_stack' => array(
            'Operatore' => __DIR__ . '/../view',
        ),
    ),

    // Module Operatore ACL
    'bjyauthorize' => array(
        'guards' => array(
            'BjyAuthorize\Guard\Controller' => array(

                // Controller Dashboard
                array('controller' => 'Operatore\Controller\Dashboard', 'roles' => array('operatore')),

                // Controller Ajax
                array('controller' => 'Operatore\Controller\Ajax', 'roles' => array('operatore')),
            ),
        ),
    ),

);
