<?php
return array(
    'controllers' => array(
        'factories' => array(
            'Marketing\Controller\Dashboard' => 'Marketing\Factory\DashboardControllerFactory',
        ),
    ),
    'router' => array(
        'routes' => array(
            'marketing' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/marketing',
                    'defaults' => array(
                        'controller' => 'Marketing\Controller\Dashboard',
                        'action' => 'index'
                    )
                )
            ),
        ),
    ),
    'view_manager' => array(
        'template_path_stack' => array(
            'Marketing' => __DIR__ . '/../view',
        ),
    ),

    // Module Marketing ACL
    'bjyauthorize' => array(
        'guards' => array(
            'BjyAuthorize\Guard\Controller' => array(

                // Controller Dashboard
                array('controller' => 'Marketing\Controller\Dashboard', 'roles' => array('comunicazione')),
            ),
        ),
    ),
);
