<?php

namespace Login\Provider;

use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;
use Login\Provider\EliminaCodeProviderIdentity;

/**
 * Class EliminaCodeProviderIdentityFactory
 * @package Login\Provider
 */
class EliminaCodeProviderIdentityFactory implements FactoryInterface
{
    /**
     * @param ServiceLocatorInterface $serviceLocator
     * @return EliminaCodeProviderIdentity|mixed
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $identityProvider = new EliminaCodeProviderIdentity($serviceLocator->get('Login\AuthService'));
        $identityProvider->setUtentiModel($serviceLocator->get('Application\Model\Utenti'));
        return $identityProvider;
    }
}
