<?php

namespace Login\Provider;

use BjyAuthorize\Provider\Identity\ProviderInterface;
use Zend\Authentication\AuthenticationService;

/**
 * Class EliminaCodeProviderIdentity
 * @package Login\Provider
 */
class EliminaCodeProviderIdentity implements ProviderInterface
{
    /**
     * @var \Zend\Authentication\AuthenticationService
     */
    protected $_authService;

    /**
     * @var
     */
    protected $_utentiModel;

    /**
     * @param AuthenticationService $authService
     */
    public function __construct(AuthenticationService $authService)
    {
        $this->_authService = $authService;
    }

    /**
     * @return array
     */
    public function getIdentityRoles()
    {
        $identity = $this->_authService->getIdentity();

        if (null != $identity) {

            $user_row = $this->getUtentiModel()->getRuolo($identity['id']);
            return array($user_row['ruolo']);

        } else {
            return array();
        }
    }

    /**
     * @param mixed $utentiModel
     */
    public function setUtentiModel($utentiModel)
    {
        $this->_utentiModel = $utentiModel;
    }

    /**
     * @return mixed
     */
    public function getUtentiModel()
    {
        return $this->_utentiModel;
    }
}
