<?php
namespace Login\Form;

use Zend\Form\Form;

/**
 * Class LoginForm
 * @package Login\Form
 */
class LoginForm extends Form
{
    public function __construct($name = null)
    {
        parent::__construct('login');
        $this->setAttribute('method', 'post');

        $this->add(array(
            'name' => 'username',
            'attributes' => array(
                'type' => 'text',
                'class' => 'input-block-level',
                'required' => 'required'
            ),
            'options' => array(
                'label' => 'Username',
            )
        ));

        $this->add(array(
            'name' => 'password',
            'attributes' => array(
                'type' => 'password',
                'class' => 'input-block-level',
                'required' => 'required'
            ),
            'options' => array(
                'label' => 'Password'
            )
        ));

        $this->add(array(
            'name' => 'submit',
            'attributes' => array(
                'type' => 'submit',
                'value' => 'Login',
                'id' => 'submitbutton'
            )
        ));
    }
}