<?php
/**
 * EliminaCode
 *
 * @copyright Copyright (c) 2014 PyxisOS Srl
 */

namespace Login\Factory;

use Login\Controller\IndexController;
use Login\Filter\LoginFilter;
use Login\Form\LoginForm;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class IndexControllerFactory implements FactoryInterface {

    public function createService(ServiceLocatorInterface $controllerManager)
    {
        $allServices = $controllerManager->getServiceLocator();
        $sm = $allServices->get('ServiceManager');

        /** @var Form $form_login */
        $form_login = new LoginForm();
        $form_login->setInputFilter(new LoginFilter());

        $controller = new IndexController();
        $controller->setLoginForm($form_login);
        return $controller;
    }
}