<?php

namespace Login\Controller\Plugin;

use Zend\Authentication\Adapter\AdapterInterface;
use Zend\Authentication\AuthenticationService;
use Zend\Mvc\Controller\Plugin\AbstractPlugin;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class EliminaCodeAuthentication
 * @package Login\Controller\Plugin
 */
class EliminaCodeAuthentication extends AbstractPlugin
{
    /**
     * @var Zend\Authentication\Adapter\AdapterInterface
     */
    protected $authAdapter;

    /**
     * @var AuthenticationService
     */
    protected $authService;

    /**
     * @var ServiceLocatorInterface
     */
    protected $serviceLocator;

    /**
     * Proxy convenience method
     *
     * @return bool
     */
    public function hasIdentity()
    {
        return $this->getAuthService()->hasIdentity();
    }

    /**
     * Proxy convenience method
     *
     * @return mixed
     */
    public function getIdentity()
    {
        return $this->getAuthService()->getIdentity();
    }

    /**
     * Get authAdapter.
     *
     * @return Zend\Authentication\Adapter\AdapterInterface
     */
    public function getAuthAdapter($name = 'eliminacode')
    {
        return $this->authAdapter[$name];
    }

    /**
     * Set authAdapter.
     *
     * @param AdapterInterface $authAdapter
     */
    public function setAuthAdapter(AdapterInterface $authAdapter, $name = 'eliminacode')
    {
        $this->authAdapter[$name] = $authAdapter;

        return $this;
    }

    /**
     * Get authService.
     *
     * @return AuthenticationService
     */
    public function getAuthService()
    {
        return $this->authService;
    }

    /**
     * Set authService.
     *
     * @param AuthenticationService $authService
     */
    public function setAuthService(AuthenticationService $authService)
    {
        $this->authService = $authService;
        return $this;
    }
}