<?php
/**
 * EliminaCode
 *
 * @copyright Copyright (c) 2014 PyxisOS Srl
 */
namespace Login\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;

class IndexController extends AbstractActionController
{
    protected $_loginForm;

    public function indexAction()
    {
        /**
         * Se è già loggato esegue il redirect
         */
        if($this->EliminaCodeAuthentication()->getAuthService()->getIdentity())
        {
            $infoUser = $this->EliminaCodeAuthentication()->getAuthService()->getIdentity();
            $infoUser['rotta'] = $this->_getRedirect($infoUser['ruolo']);
            return $infoUser['rotta'];
        }

        $request = $this->getRequest();
        $form    = $this->getLoginForm();

        if ($request->isPost()) {
            $form->setData($request->getPost());

            if (!$form->isValid()) {
                $this->flashMessenger()->addMessage('Username o Password Errata!');
                return $this->redirect()->toRoute('login');
            }

            $data    = $form->getData();
            $adapter = $this->EliminaCodeAuthentication()->getAuthAdapter();
            $adapter->setUsername($data['username']);
            $adapter->setPassword($data['password']);

            $auth = $this->EliminaCodeAuthentication()->getAuthService()->authenticate($adapter);

            if (!$auth->isValid()) {
                $this->flashMessenger()->addMessage('Username o Password Errata!');
                return $this->redirect()->toRoute('login');
            }

            $infoUser = $this->EliminaCodeAuthentication()->getAuthService()->getIdentity();
            $infoUser['rotta'] = $this->_getRedirect($infoUser['ruolo']);
            return $infoUser['rotta'];
        }

        return new ViewModel(array(
            'form'     => $this->getLoginForm(),
            'message'  => $this->flashMessenger()->getMessages()
        ));
    }

    public function logoutAction()
    {
        $this->EliminaCodeAuthentication()->getAuthService()->clearIdentity();
        return $this->redirect()->toRoute('login');
    }

    public function dashboardAction()
    {
        if($this->EliminaCodeAuthentication()->getAuthService()->getIdentity())
        {
            $infoUser = $this->EliminaCodeAuthentication()->getAuthService()->getIdentity();
            $infoUser['rotta'] = $this->_getRedirect($infoUser['ruolo']);
            return $infoUser['rotta'];
        }
    }

    /**
     * @param mixed $loginForm
     */
    public function setLoginForm($loginForm)
    {
        $this->_loginForm = $loginForm;
    }

    /**
     * @return mixed
     */
    public function getLoginForm()
    {
        return $this->_loginForm;
    }

    /**
     * @param $ruolo
     * @return string
     */
    private function _getRedirect($ruolo)
    {
        switch($ruolo)
        {
            case \Application\Model\Ruoli::RUOLO_SUPER_AMMINISTRATORE:
                return $this->redirect()->toRoute('admin_dashboard', array('action' => 'super-amministratore'));
            break;

            case \Application\Model\Ruoli::RUOLO_AMMINISTRATORE:
                return $this->redirect()->toRoute('admin_dashboard', array('action' => 'amministratore'));
            break;

            case \Application\Model\Ruoli::RUOLO_OPERATORE:
                return $this->redirect()->toRoute('operatore');
            break;

            case \Application\Model\Ruoli::RUOLO_INFERMIERE:
                return $this->redirect()->toRoute('infermiere');
            break;

            case \Application\Model\Ruoli::RUOLO_MEDICO:
                return $this->redirect()->toRoute('medico');
            break;

            case \Application\Model\Ruoli::RUOLO_COMUNICAZIONE:
                return $this->redirect()->toRoute('marketing');
            break;
        }
    }
}
