<?php
return array(
    'controllers' => array(
        'factories' => array(
            'Login\Controller\Index' => 'Login\Factory\IndexControllerFactory'
        ),
    ),
    'router' => array(
        'routes' => array(
            'login' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/',
                    'defaults' => array(
                        'controller'    => 'Login\Controller\Index',
                        'action'        => 'index',
                    ),
                ),
            ),
            'logout' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/logout',
                    'defaults' => array(
                        'controller'    => 'Login\Controller\Index',
                        'action'        => 'logout',
                    ),
                ),
            ),
            'get-dashboard' => array(
                'type'    => 'segment',
                'options' => array(
                    'route'    => '/get-dashboard',
                    'defaults' => array(
                        'controller'    => 'Login\Controller\Index',
                        'action'        => 'dashboard',
                    ),
                ),
            ),
        ),
    ),
    'service_manager' => array(
        'invokables' => array(
            'Login\AuthService' => 'Zend\Authentication\AuthenticationService',
        ),
        'factories' => array(
            'Login\AuthAdapter\EliminaCode' => function ($sm) {
                $UtentiModel = $sm->get('Application\Model\Utenti');
                return new Login\Authentication\Adapter\EliminaCode($UtentiModel);
            },
            'Login\Provider\EliminaCodeProviderIdentity' => 'Login\Provider\EliminaCodeProviderIdentityFactory',
        )
    ),
    'view_manager' => array(
        'template_path_stack' => array(
            'Login' => __DIR__ . '/../view',
        ),
    ),

    // Module Login ACL
    'bjyauthorize' => array(
        'guards' => array(
            'BjyAuthorize\Guard\Controller' => array(

                // Controller Dashboard
                array('controller' => 'Login\Controller\Index', 'roles' => array()),
            ),
        ),
    ),
);