<?php
namespace Login;

class Module
{
    public function getConfig()
    {
        return include __DIR__ . '/config/module.config.php';
    }

    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ),
            ),
        );
    }

    /**
     * @return array
     */
    public function getControllerPluginConfig()
    {
        return array(
            'factories' => array(

                /** Authentication */
                'EliminaCodeAuthentication' => function ($sm) {
                    $serviceLocator = $sm->getServiceLocator();
                    $authService = $serviceLocator->get('Login\AuthService');
                    $authAdapterEliminaCode = $serviceLocator->get('Login\AuthAdapter\EliminaCode');
                    $controllerPlugin = new Controller\Plugin\EliminaCodeAuthentication();
                    $controllerPlugin->setAuthService($authService);
                    $controllerPlugin->setAuthAdapter($authAdapterEliminaCode);
                    return $controllerPlugin;
                },
            )
        );
    }
}
