<?php
namespace Application\Service;

use Zend\ServiceManager\ServiceLocatorAwareInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class ModalitaService
 * @package Application\Service
 */
class ModalitaService implements ServiceLocatorAwareInterface
{
    /**
     * @var ServiceLocatorInterface
     */
    protected $_ServiceLocator;

    /**
     * @param \Zend\ServiceManager\ServiceLocatorInterface $ServiceLocator
     */
    public function setServiceLocator(ServiceLocatorInterface $ServiceLocator)
    {
        $this->_ServiceLocator = $ServiceLocator;
    }

    /**
     * @return \Zend\ServiceManager\ServiceLocatorInterface
     */
    public function getServiceLocator()
    {
        return $this->_ServiceLocator;
    }

    /**
     * @return array
     */
    public function getModalita()
    {
        /** @var Status $Status */
        $modalita  = $this->getServiceLocator()->get('Application\Model\Modalita');
        $option = array();
        foreach ($modalita->full() as $row) {
            $option[$row['id']] = $row['nome'];
        }

        return $option;
    }
}
