<?php
/**
 * EliminaCode
 *
 * @copyright Copyright (c) 2014 PyxisOS Srl
 */
namespace Application\Model;

use Zend\Db\Adapter\Adapter;
use Zend\Db\Sql\Sql;

/**
 * Class Utenti
 * @package Application\Model
 */
class Utenti
{

    const TABLE = 'ec_utenti';

    public $adapter;
    public $sql;

    protected $_whitelist = array(
        'id_ruolo',
        'status',
        'username',
        'password',
        'nome',
        'cognome',
        'codice_fiscale',
        'email',
        'cap',
        'citta',
        'indirizzo',
        'telefono',
        'cellulare'
    );

    public function __construct(Adapter $adapter)
    {
        $this->adapter = $adapter;
        $this->sql     = new Sql($adapter);
    }

    /**
     * @param array $data
     * @return mixed
     */
    public function insert(array $data)
    {
        $values = array_intersect_key($data, array_flip($this->_whitelist));

        $insert = $this->sql->insert(self::TABLE);
        $insert->values($values);

        $statement = $this->sql->prepareStatementForSqlObject($insert);

        return $statement->execute()->getGeneratedValue();
    }

    /**
     * @param $id
     * @param array $values
     * @return mixed
     */
    public function update($id, array $values)
    {
        $where = new \Zend\Db\Sql\Where();
        $where->equalTo('id', (int)$id);

        $values = array_intersect_key($values, array_flip($this->_whitelist));

        $update = $this->sql->update(self::TABLE);
        $update->set($values)->where($where);

        $statement = $this->sql->prepareStatementForSqlObject($update);

        return $statement->execute()->getGeneratedValue();
    }

    /**
     * @param array $filterBy
     * @return mixed
     */
    public function findEqual($filterBy = array())
    {
        $select = $this->sql->select();
        $select->from(self::TABLE)->where($filterBy);

        $statement = $this->sql->prepareStatementForSqlObject($select);

        return $statement->execute()->current();
    }

    /**
     * @return \Zend\Db\Adapter\Driver\ResultInterface
     */
    public function full()
    {
        $select = $this->sql->select();
        $select->from(array('u' => self::TABLE));
        $select->join(array('r' => 'ec_ruoli'), 'r.id = u.id_ruolo', array('nome_ruolo' => 'ruolo'), 'left');
        $select->order('u.id ASC');
        $statement = $this->sql->prepareStatementForSqlObject($select);

        return $statement->execute();
    }

    /**
     * @param int $id
     * @return \Zend\Db\Adapter\Driver\ResultInterface
     */
    public function delete($id)
    {
        $delete = $this->sql->delete(self::TABLE);
        $delete->where(array(
            'id' => $id
        ));
        $deleteStatement = $this->sql->prepareStatementForSqlObject($delete);

        return $deleteStatement->execute();
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getRuolo($id)
    {
        $select = $this->sql->select();
        $select->from(array('u' => self::TABLE))
            ->columns(array('id'))
            ->join(array('r' => 'ec_ruoli'), 'r.id = u.id_ruolo', 'ruolo')
            ->where(array('u.id' => $id));
        $statement = $this->sql->prepareStatementForSqlObject($select);

        return $statement->execute()->current();
    }
}
