<?php
/**
 * EliminaCode
 *
 * @copyright Copyright (c) 2014 PyxisOS Srl
 */
namespace Application\Model;

use Zend\Db\Adapter\Adapter;
use Zend\Db\Sql\Sql;

/**
 * Class Status
 * @package Application\Model
 */
class Status
{
    const TABLE = 'ec_status';
    const STATUS_ATTIVO = 1;
    const STATUS_NON_ATTIVO = 2;

    /**
     * @var \Zend\Db\Adapter\Adapter
     */
    public $adapter;

    /**
     * @var \Zend\Db\Sql\Sql
     */
    public $sql;

    /**
     * @param Adapter $adapter
     */
    public function __construct(Adapter $adapter)
    {
        $this->adapter = $adapter;
        $this->sql     = new Sql($adapter);
    }

    /**
     * @param array $filterBy
     * @return mixed
     */
    public function full($filterBy = array())
    {
        $select = $this->sql->select();
        $select->from(self::TABLE)->where($filterBy);

        $statement = $this->sql->prepareStatementForSqlObject($select);

        return $statement->execute();
    }
}
