<?php
namespace Application\Model;

use Zend\Db\Adapter\Adapter;
use Zend\Db\Sql\Sql;

/**
 * Class Ruoli
 * @package Application\Model
 */
class Ruoli
{
    const TABLE                      = 'ec_ruoli';
    const RUOLO_SUPER_AMMINISTRATORE = 'super-amministratore';
    const RUOLO_AMMINISTRATORE       = 'amministratore';
    const RUOLO_OPERATORE            = 'operatore';
    const RUOLO_INFERMIERE           = 'infermiere';
    const RUOLO_MEDICO               = 'medico';
    const RUOLO_COMUNICAZIONE        = 'comunicazione';

    /**
     * @var \Zend\Db\Adapter\Adapter
     */
    public $adapter;

    /**
     * @var \Zend\Db\Sql\Sql
     */
    public $sql;

    /**
     * @var array
     */
    protected $_whitelist = array(
        'nome',
        'status'
    );

    /**
     * @param Adapter $adapter
     */
    public function __construct(Adapter $adapter)
    {
        $this->adapter = $adapter;
        $this->sql     = new Sql($adapter);
    }

    /**
     * @return \Zend\Db\Adapter\Driver\ResultInterface
     */
    public function full()
    {
        $select = $this->sql->select();
        $select->from(self::TABLE);
        $select->order('id ASC');
        $statement = $this->sql->prepareStatementForSqlObject($select);
        $dataset   = $statement->execute();

        return $dataset;
    }
}
