<?php
namespace Application;

use Application\Model\Modalita;
use Application\Model\ProgrammaModalita;
use Application\Model\ProgrammaSportelli;
use Application\Model\Ruoli;
use Application\Model\Sportelli;
use Application\Model\Status;
use Application\Model\Utenti;
use Zend\Mvc\ModuleRouteListener;
use Zend\Mvc\MvcEvent;

/**
 * Class Module
 * @package Application
 */
class Module
{
    /**
     * @param MvcEvent $e
     */
    public function onBootstrap(MvcEvent $e)
    {
        $eventManager        = $e->getApplication()->getEventManager();
        $serviceManager      = $e->getApplication()->getServiceManager();
        $moduleRouteListener = new ModuleRouteListener();
        $moduleRouteListener->attach($eventManager);

        $AuthService = $serviceManager->get('Login\AuthService');
        $vm          = $e->getViewModel();

        if ($AuthService->hasIdentity()) {
            $infoUser = $serviceManager->get('ControllerPluginManager')->get('EliminaCodeAuthentication')->getIdentity();
            $vm->setVariable('utente', $infoUser);
        }
    }

    /**
     * @return mixed
     */
    public function getConfig()
    {
        return include __DIR__ . '/config/module.config.php';
    }

    /**
     * @return array
     */
    public function getAutoloaderConfig()
    {
        return array(
            'Zend\Loader\StandardAutoloader' => array(
                'namespaces' => array(
                    __NAMESPACE__ => __DIR__ . '/src/' . __NAMESPACE__,
                ),
            ),
        );
    }

    /**
     * @return array
     */
    public function getServiceConfig()
    {
        return array(
            'factories' => array(
                'Application\Model\Utenti' => function ($sm) {
                        $dbAdapter = $sm->get('Zend\Db\Adapter\Adapter');
                        return new Utenti($dbAdapter);
                    },
                'Application\Model\Modalita' => function ($sm) {
                        $dbAdapter = $sm->get('Zend\Db\Adapter\Adapter');
                        return new Modalita($dbAdapter);
                    },
                'Application\Model\Ruoli' => function ($sm) {
                        $dbAdapter = $sm->get('Zend\Db\Adapter\Adapter');
                        return new Ruoli($dbAdapter);
                    },
                'Application\Model\Status' => function ($sm) {
                        $dbAdapter = $sm->get('Zend\Db\Adapter\Adapter');
                        return new Status($dbAdapter);
                    },
                'Application\Model\ProgrammaModalita' => function ($sm) {
                        $dbAdapter = $sm->get('Zend\Db\Adapter\Adapter');
                        return new ProgrammaModalita($dbAdapter);
                    },
            ),
        );
    }

    public function getViewHelperConfig()
    {
        return array(
            'factories' => array(
                'status_helper' => function($sm) {
                    $helper = new View\Helper\StatusHelper();
                    return $helper;
                }
            )
        );
    }
}
