<?php
namespace Admin\Service;

use Zend\ServiceManager\ServiceLocatorAwareInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class StatusService
 * @package Admin\Service
 */
class StatusService implements ServiceLocatorAwareInterface
{
    /**
     * @var ServiceLocatorInterface
     */
    protected $_ServiceLocator;

    /**
     * @param \Zend\ServiceManager\ServiceLocatorInterface $ServiceLocator
     */
    public function setServiceLocator(ServiceLocatorInterface $ServiceLocator)
    {
        $this->_ServiceLocator = $ServiceLocator;
    }

    /**
     * @return \Zend\ServiceManager\ServiceLocatorInterface
     */
    public function getServiceLocator()
    {
        return $this->_ServiceLocator;
    }

    /**
     * @return array
     */
    public function getStatus()
    {
        /** @var Status $Status */
        $Status  = $this->getServiceLocator()->get('Application\Model\Status');
        $option = array();
        foreach ($Status->full() as $row) {
            $option[$row['id']] = $row['nome_status'];
        }

        return $option;
    }
}
