<?php
namespace Admin\Service;

use Application\Model\Ruoli;
use Zend\ServiceManager\ServiceLocatorAwareInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class RuoliService
 * @package Admin\Service
 */
class RuoliService implements ServiceLocatorAwareInterface
{
    /**
     * @var ServiceLocatorInterface
     */
    protected $_ServiceLocator;

    /**
     * @param \Zend\ServiceManager\ServiceLocatorInterface $ServiceLocator
     */
    public function setServiceLocator(ServiceLocatorInterface $ServiceLocator)
    {
        $this->_ServiceLocator = $ServiceLocator;
    }

    /**
     * @return \Zend\ServiceManager\ServiceLocatorInterface
     */
    public function getServiceLocator()
    {
        return $this->_ServiceLocator;
    }

    /**
     * @return array
     */
    public function getOptionValue()
    {
        /** @var Ruoli $Ruoli */
        $Ruoli  = $this->getServiceLocator()->get('Application\Model\Ruoli');
        $option = array();
        foreach ($Ruoli->full() as $row) {
            $option[$row['id']] = $row['ruolo'];
        }

        return $option;
    }
}
