<?php
namespace Admin\Form;

use Zend\Form\Form;

/**
 * Class UtentiForm
 * @package Admin\Form
 */
class UtentiForm extends Form
{
    /**
     * @param string $name
     * @param array $options
     */
    public function __construct($name = '', $options = array())
    {
        parent::__construct($name);

        $this->setAttribute('method', 'post');

        $this->add(array(
            'name' => 'id_ruolo',
            'type' => 'Zend\Form\Element\Select',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            ),
            'options' => array(
                'empty_option' => '-- Seleziona Ruolo --',
                'value_options' => $options['ruolo']
            )
        ));

        $this->add(array(
            'name' => 'status',
            'type' => 'Zend\Form\Element\Select',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            ),
            'options' => array(
                'value_options' => $options['status']
            )
        ));

        $this->add(array(
            'name' => 'username',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'password',
            'type' => 'Zend\Form\Element\Password',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => ''
            )
        ));

        $this->add(array(
            'name' => 'nome',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'cognome',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'codice_fiscale',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'email',
            'type' => 'Zend\Form\Element\Email',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'cap',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'citta',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'indirizzo',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'telefono',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));

        $this->add(array(
            'name' => 'cellulare',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            )
        ));
    }
}
