<?php
namespace Admin\Form;

use Zend\Form\Form;

/**
 * Class ProgrammaModalitaForm
 * @package Admin\Form
 */
class ProgrammaModalitaForm extends Form
{
    /**
     * @param string $name
     * @param array $options
     */
    public function __construct($name = '', $options = array())
    {
        parent::__construct($name);

        $this->setAttribute('method', 'post');

        $this->add(array(
            'name' => 'id_modalita',
            'type' => 'Zend\Form\Element\Select',
            'attributes' => array(
                'class' => 'input-block-level',
                'required' => 'required'
            ),
            'options' => array(
                'empty_option' => '-- Seleziona Modalità --',
                'value_options' => $options['modalita']
            )
        ));

        $this->add(array(
            'name' => 'data_inizio',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'data-format' => 'yyyy-MM-dd hh:mm:ss',
                'class' => 'input-block-level',
                'required' => 'required',
                'readonly' => 'readonly'
            )
        ));

        $this->add(array(
            'name' => 'data_fine',
            'type' => 'Zend\Form\Element\Text',
            'attributes' => array(
                'data-format' => 'yyyy-MM-dd hh:mm:ss',
                'class' => 'input-block-level',
                'required' => 'required',
                'readonly' => 'readonly'
            )
        ));
    }
}
