<?php
namespace Admin\Filter;

use Zend\InputFilter\InputFilter;

/**
 * Class UtentiFilter
 * @package Admin\Filter
 */
class UtentiFilter extends InputFilter
{
    /**
     * @param array $params
     */
    public function __construct($params = array())
    {
        $this->add(array(
            'name' => 'nome',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'username',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                ),
                array(
                    'name' => 'Db\NoRecordExists',
                    'options' => array(
                        'adapter' => $params['adapter'],
                        'table' => 'ec_utenti',
                        'field' => 'username',
                        'exclude' => array(
                            'field' => 'id',
                            'value' => $params['id']
                        )
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'password',
            'required' => $params['required_password'],
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '255'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'nome',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'cognome',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'codice_fiscale',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'email',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                ),
                array(
                    'name' => 'EmailAddress',
                    'options' => array(
                        'messages' => array(
                            'emailAddressInvalidFormat' => 'Email address format is not invalid'
                        )
                    )
                ),
                array(
                    'name' => 'NotEmpty',
                    'options' => array(
                        'messages' => array(
                            'isEmpty' => 'Email address is required'
                        )
                    )
                ),
                array(
                    'name' => 'Db\NoRecordExists',
                    'options' => array(
                        'adapter' => $params['adapter'],
                        'table' => 'ec_utenti',
                        'field' => 'email',
                        'exclude' => array(
                            'field' => 'id',
                            'value' => $params['id']
                        )
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'cap',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'citta',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'indirizzo',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'telefono',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'cellulare',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

    }
}
