<?php
namespace Admin\Filter;

use Zend\InputFilter\InputFilter;

/**
 * Class ModalitaFilter
 * @package Admin\Filter
 */
class ModalitaFilter extends InputFilter
{
    public function __construct()
    {
        $this->add(array(
            'name' => 'codice',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));

        $this->add(array(
            'name' => 'nome',
            'required' => true,
            'filters' => array(
                array('name' => 'StripTags'),
                array('name' => 'StringTrim')
            ),
            'validators' => array(
                array(
                    'name' => 'StringLength',
                    'options' => array(
                        'encoding' => 'UTF-8',
                        'min' => '1',
                        'max' => '45'
                    )
                )
            )
        ));
    }
}
