<?php
namespace Admin\Factory;

use Admin\Controller\UtentiController;
use Admin\Form\UtentiForm;
use Admin\Service\RuoliService;
use Admin\Service\StatusService;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class UtentiControllerFactory
 * @package Admin\Factory
 */
class UtentiControllerFactory implements FactoryInterface
{
    /**
     * @param ServiceLocatorInterface $controllerManager
     * @return UtentiController|mixed
     */
    public function createService(ServiceLocatorInterface $controllerManager)
    {
        $allServices = $controllerManager->getServiceLocator();
        $sm          = $allServices->get('ServiceManager');

        /** @var RuoliService $RuoliService */
        $RuoliService = $sm->get('Admin\Service\RuoliService');

        /** @var StatusService $StatusService */
        $StatusService = $sm->get('Admin\Service\StatusService');

        $form = new UtentiForm('', array(
            'ruolo' => $RuoliService->getOptionValue(),
            'status' => $StatusService->getStatus(array(
                    'id' => \Application\Model\Status::STATUS_ATTIVO,
                    'id' => \Application\Model\Status::STATUS_NON_ATTIVO
                ))
        ));

        $controller = new UtentiController();
        $controller->setUtentiForm($form);
        $controller->setUtenti($sm->get('Application\Model\Utenti'));

        return $controller;
    }

}