<?php
/**
 * EliminaCode
 *
 * @copyright Copyright (c) 2014 PyxisOS Srl
 */

namespace Admin\Factory;

use Admin\Controller\ProgrammaModalitaController;
use Admin\Filter\ProgrammaModalitaFilter;
use Admin\Form\ProgrammaModalitaForm;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class ProgrammaModalitaControllerFactory
 * @package Admin\Factory
 */
class ProgrammaModalitaControllerFactory implements FactoryInterface {

    public function createService(ServiceLocatorInterface $controllerManager)
    {
        $allServices = $controllerManager->getServiceLocator();
        $sm = $allServices->get('ServiceManager');

        $ModalitaService = $sm->get('Application\Service\ModalitaService');

        $form = new ProgrammaModalitaForm('', array(
            'modalita' => $ModalitaService->getModalita()
        ));
        $form->setInputFilter(new ProgrammaModalitaFilter());

        $controller = new ProgrammaModalitaController();
        $controller->setProgrammaModalitaForm($form);
        $controller->setPrgrammaModalitaModel($sm->get('Application\Model\ProgrammaModalita'));
        return $controller;
    }

}