<?php
namespace Admin\Factory;

use Admin\Controller\ModalitaController;
use Admin\Filter\ModalitaFilter;
use Admin\Form\ModalitaForm;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Class ModalitaControllerFactory
 * @package Admin\Factory
 */
class ModalitaControllerFactory implements FactoryInterface
{
    /**
     * @param ServiceLocatorInterface $controllerManager
     * @return ModalitaController|mixed
     */
    public function createService(ServiceLocatorInterface $controllerManager)
    {
        $allServices = $controllerManager->getServiceLocator();
        $sm          = $allServices->get('ServiceManager');

        $form = new ModalitaForm();
        $form->setInputFilter(new ModalitaFilter());

        $controller = new ModalitaController();
        $controller->setModalitaForm($form);
        $controller->setModalitaModel($sm->get('Application\Model\Modalita'));

        return $controller;
    }

}