<?php
namespace Admin\Controller;

use Admin\Filter\UtentiFilter;
use Admin\Form\UtentiForm;
use Application\Model\Utenti;
use Zend\Crypt\Password\Bcrypt;
use Zend\Mvc\Controller\AbstractActionController;

/**
 * Class UtentiController
 * @package Admin\Controller
 */
class UtentiController extends AbstractActionController
{
    /**
     * @var UtentiForm
     */
    protected $_UtentiForm;

    /**
     * @var Utenti
     */
    protected $_Utenti;

    /**
     * @param \Application\Model\Utenti $Utenti
     */
    public function setUtenti($Utenti)
    {
        $this->_Utenti = $Utenti;
    }

    /**
     * @return \Application\Model\Utenti
     */
    public function getUtenti()
    {
        return $this->_Utenti;
    }

    /**
     * @param \Admin\Form\UtentiForm $UtentiForm
     */
    public function setUtentiForm($UtentiForm)
    {
        $this->_UtentiForm = $UtentiForm;
    }

    /**
     * @return \Admin\Form\UtentiForm
     */
    public function getUtentiForm()
    {
        return $this->_UtentiForm;
    }

    /**
     * @return array
     */
    public function indexAction()
    {
        return array(
            'utenti' => $this->getUtenti()->full(),
            'message' => $this->flashMessenger()->getMessages()
        );
    }

    /**
     * @return array|\Zend\Http\Response
     */
    public function aggiungiAction()
    {
        $request = $this->getRequest();
        $form    = $this->getUtentiForm();

        $bcrypt  = new Bcrypt();
        $Adapter = $this->getServiceLocator()->get('Zend\Db\Adapter\Adapter');

        if (true === $request->isPost()) {

            $post = $request->getPost()->toArray();


            $form->setData($post);
            $form->setInputFilter(new UtentiFilter(array(
                'adapter' => $Adapter,
                'id' => 0,
                'required_password' => true
            )));

            if (true === $form->isValid()) {

                $post['password'] = $bcrypt->create($post['password']);
                $this->getUtenti()->insert($post);
                $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

                return $this->redirect()->toRoute('admin_utenti');
            }
        }

        return array('form' => $form);
    }

    /**
     * @return array|\Zend\Http\Response
     */
    public function modificaAction()
    {
        $ID = (int)$this->params()->fromRoute('id', 0);

        $bcrypt  = new Bcrypt();
        $Adapter = $this->getServiceLocator()->get('Zend\Db\Adapter\Adapter');

        $row = $this->getUtenti()->findEqual(array('id' => $ID));

        $request = $this->getRequest();
        $form    = $this->getUtentiForm();
        $form->setData($row);

        if (true === $request->isPost()) {

            $post = $request->getPost()->toArray();
            $form->setData($post);
            $form->setInputFilter(new UtentiFilter(array(
                'adapter' => $Adapter,
                'id' => $ID,
                'required_password' => false
            )));

            if (true === $form->isValid()) {

                if (!empty($post['password'])) {
                    $post['password'] = $bcrypt->create($post['password']);
                } else {
                    $post['password'] = $row['password'];
                }

                $this->getUtenti()->update($ID, $post);
                $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

                return $this->redirect()->toRoute('admin_utenti');
            }
        }

        return array('form' => $form);
    }

    /**
     * @return \Zend\Http\Response
     */
    public function eliminaAction()
    {
        $ID = (int)$this->params()->fromRoute('id', 0);
        $this->getUtenti()->delete($ID);
        $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

        return $this->redirect()->toRoute('admin_utenti');
    }
}
