<?php
namespace Admin\Controller;

use Admin\Form\ProgrammaSportelliForm;
use Application\Model\ProgrammaSportelli;
use Application\Model\Sportelli;
use Zend\Mvc\Controller\AbstractActionController;

/**
 * Class ProgrammaModalitaController
 * @package Admin\Controller
 */
class ProgrammaModalitaController extends AbstractActionController
{
    /**
     * @var
     */
    protected $_programmaModalitaForm;

    /**
     * @var
     */
    protected $_prgrammaModalitaModel;

    /**
     * @param mixed $prgrammaModalitaModel
     */
    public function setPrgrammaModalitaModel($prgrammaModalitaModel)
    {
        $this->_prgrammaModalitaModel = $prgrammaModalitaModel;
    }

    /**
     * @return mixed
     */
    public function getPrgrammaModalitaModel()
    {
        return $this->_prgrammaModalitaModel;
    }

    /**
     * @param mixed $programmaModalitaForm
     */
    public function setProgrammaModalitaForm($programmaModalitaForm)
    {
        $this->_programmaModalitaForm = $programmaModalitaForm;
    }

    /**
     * @return mixed
     */
    public function getProgrammaModalitaForm()
    {
        return $this->_programmaModalitaForm;
    }

    /**
     * @return array
     */
    public function indexAction()
    {
        $utente = (int)$this->params()->fromRoute('utente', 0);

        return array(
            'utente' => $utente,
            'modalita' => $this->getPrgrammaModalitaModel()->fullEqual(array(
                'id_utente' => $utente
            ))
        );
    }

    /**
     * @return array|\Zend\Http\Response
     */
    public function aggiungiAction()
    {
        $utente = (int)$this->params()->fromRoute('utente', 0);

        $request = $this->getRequest();
        $form    = $this->getProgrammaModalitaForm();

        if (true === $request->isPost()) {

            $post              = $request->getPost()->toArray();
            $post['id_utente'] = $utente;
            $form->setData($post);

            if (true === $form->isValid()) {
                $this->getPrgrammaModalitaModel()->insert($post);
                $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

                return $this->redirect()->toRoute('programma_modalita/default', array(
                    'action' => 'index',
                    'utente' => $utente
                ));
            }
        }

        return array('form' => $form);
    }

    /**
     * @return array|\Zend\Http\Response
     */
    public function modificaAction()
    {
        $utente = (int)$this->params()->fromRoute('utente', 0);
        $ID        = (int)$this->params()->fromRoute('id', 0);

        $row = $this->getPrgrammaModalitaModel()->findEqual(array('id' => $ID));

        $request = $this->getRequest();
        $form    = $this->getProgrammaModalitaForm();
        $form->setData($row);

        if (true === $request->isPost()) {

            $post = $request->getPost()->toArray();
            $form->setData($post);

            if (true === $form->isValid()) {
                $this->getPrgrammaModalitaModel()->update($ID, $post);
                $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

                return $this->redirect()->toRoute('programma_modalita/default', array(
                    'action' => 'index',
                    'utente' => $utente
                ));
            }
        }

        return array('form' => $form);
    }

    /**
     * @return \Zend\Http\Response
     */
    public function eliminaAction()
    {
        $utente = (int)$this->params()->fromRoute('utente', 0);
        $ID        = (int)$this->params()->fromRoute('id', 0);

        $this->getPrgrammaModalitaModel()->delete($ID);
        $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

        return $this->redirect()->toRoute('programma_modalita/default', array(
            'action' => 'index',
            'utente' => $utente
        ));
    }
}
