<?php
namespace Admin\Controller;

use Zend\Mvc\Controller\AbstractActionController;

/**
 * Class ModalitaController
 * @package Admin\Controller
 */
class ModalitaController extends AbstractActionController
{

    /**
     * @var
     */
    protected $_ModalitaForm;

    /**
     * @var
     */
    protected $_ModalitaModel;

    /**
     * @param mixed $ModalitaForm
     */
    public function setModalitaForm($ModalitaForm)
    {
        $this->_ModalitaForm = $ModalitaForm;
    }

    /**
     * @return mixed
     */
    public function getModalitaForm()
    {
        return $this->_ModalitaForm;
    }

    /**
     * @param mixed $ModalitaModel
     */
    public function setModalitaModel($ModalitaModel)
    {
        $this->_ModalitaModel = $ModalitaModel;
    }

    /**
     * @return mixed
     */
    public function getModalitaModel()
    {
        return $this->_ModalitaModel;
    }

    /**
     * @return array
     */
    public function indexAction()
    {
        return array(
            'modalita' => $this->getModalitaModel()->full(),
            'message' => $this->flashMessenger()->getMessages()
        );
    }

    /**
     * @return array|\Zend\Http\Response
     */
    public function aggiungiAction()
    {
        $request = $this->getRequest();
        $form    = $this->getModalitaForm();

        if (true === $request->isPost()) {

            $post = $request->getPost()->toArray();
            $form->setData($post);

            if (true === $form->isValid()) {
                $this->getModalitaModel()->insert($post);
                $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

                return $this->redirect()->toRoute('admin_modalita');
            }
        }

        return array('form' => $form);
    }

    /**
     * @return array|\Zend\Http\Response
     */
    public function modificaAction()
    {
        $ID      = (int)$this->params()->fromRoute('id', 0);
        $row     = $this->getModalitaModel()->findEqual(array('id' => $ID));
        $request = $this->getRequest();

        $form = $this->getModalitaForm();
        $form->setData($row);

        if (true === $request->isPost()) {

            $post = $request->getPost()->toArray();
            $form->setData($post);

            if (true === $form->isValid()) {
                $this->getModalitaModel()->update($ID, $post);
                $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

                return $this->redirect()->toRoute('admin_modalita');
            }
        }

        return array('form' => $form);
    }

    /**
     * @return \Zend\Http\Response
     */
    public function eliminaAction()
    {
        $ID = (int)$this->params()->fromRoute('id', 0);
        $this->getModalitaModel()->delete($ID);
        $this->flashMessenger()->addMessage('Operazione eseguita con successo!');

        return $this->redirect()->toRoute('admin_modalita');
    }
}
