<?php
return array(
    'controllers' => array(
        'factories' => array(
            'Admin\Controller\Dashboard' => 'Admin\Factory\DashboardControllerFactory',
            'Admin\Controller\Utenti' => 'Admin\Factory\UtentiControllerFactory',
            'Admin\Controller\Modalita' => 'Admin\Factory\ModalitaControllerFactory',
            'Admin\Controller\ProgrammaModalita' => 'Admin\Factory\ProgrammaModalitaControllerFactory',
        ),
    ),
    'router' => array(
        'routes' => array(

            'admin_dashboard' => array(
                'type' => 'Zend\Mvc\Router\Http\Segment',
                'options' => array(
                    'route' => '/admin/[:action]',
                    'defaults' => array(
                        'controller' => 'Admin\Controller\Dashboard',
                        'action' => '[a-zA-Z][a-zA-Z0-9_\/-]*'
                    )
                )
            ),

            'admin_utenti' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/admin/utenti',
                    'defaults' => array(
                        'controller' => 'Admin\Controller\Utenti',
                        'action' => 'index'
                    )
                ),
                'may_terminate' => true,
                'child_routes' => array(
                    'default' => array(
                        'type' => 'Zend\Mvc\Router\Http\Segment',
                        'options' => array(
                            'route' => '/[:action[/:id]]',
                            'constraints' => array(
                                'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'id' => '[0-9]+'
                            ),
                            'defaults' => array()
                        )
                    )
                )
            ),

            'admin_modalita' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/admin/modalita',
                    'defaults' => array(
                        'controller' => 'Admin\Controller\Modalita',
                        'action' => 'index'
                    )
                ),
                'may_terminate' => true,
                'child_routes' => array(
                    'default' => array(
                        'type' => 'Zend\Mvc\Router\Http\Segment',
                        'options' => array(
                            'route' => '/[:action[/:id]]',
                            'constraints' => array(
                                'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'id' => '[0-9]+'
                            ),
                            'defaults' => array()
                        )
                    )
                )
            ),

            'programma_modalita' => array(
                'type' => 'Zend\Mvc\Router\Http\Literal',
                'options' => array(
                    'route' => '/admin/programma-modalita',
                    'defaults' => array(
                        'controller' => 'Admin\Controller\ProgrammaModalita',
                        'action' => 'index'
                    )
                ),
                'may_terminate' => true,
                'child_routes' => array(
                    'default' => array(
                        'type' => 'Zend\Mvc\Router\Http\Segment',
                        'options' => array(
                            'route' => '/[:action[/:utente][/:id]]',
                            'constraints' => array(
                                'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'utente' => '[0-9]+',
                                'id' => '[0-9]+'
                            ),
                            'defaults' => array()
                        )
                    )
                )
            ),


        ),
    ),
    'view_manager' => array(
        'template_path_stack' => array(
            'Admin' => __DIR__ . '/../view',
        ),
    ),

    'service_manager' => array(
        'invokables' => array(
            'Admin\Service\RuoliService' => 'Admin\Service\RuoliService',
            'Admin\Service\StatusService' => 'Admin\Service\StatusService',
        ),
    ),

    // Module Admin ACL
    'bjyauthorize' => array(
        'guards' => array(
            'BjyAuthorize\Guard\Controller' => array(

                // Controller Dashboard
                array('controller' => 'Admin\Controller\Dashboard', 'action' => 'super-amministratore', 'roles' => array('super-amministratore')),
                array('controller' => 'Admin\Controller\Dashboard', 'action' => 'amministratore', 'roles' => array('amministratore')),

                //Controller Modalita
                array('controller' => 'Admin\Controller\Modalita', 'action' => 'index', 'roles' => array('super-amministratore', 'amministratore')),
                array('controller' => 'Admin\Controller\Modalita', 'action' => 'aggiungi', 'roles' => array('super-amministratore', 'amministratore')),
                array('controller' => 'Admin\Controller\Modalita', 'action' => 'modifica', 'roles' => array('super-amministratore', 'amministratore')),
                array('controller' => 'Admin\Controller\Modalita', 'action' => 'elimina', 'roles' => array('super-amministratore', 'amministratore')),

                //Controller Utenti
                array('controller' => 'Admin\Controller\Utenti', 'action' => 'index', 'roles' => array('super-amministratore', 'amministratore')),
                array('controller' => 'Admin\Controller\Utenti', 'action' => 'aggiungi', 'roles' => array('super-amministratore', 'amministratore')),
                array('controller' => 'Admin\Controller\Utenti', 'action' => 'modifica', 'roles' => array('super-amministratore', 'amministratore')),
                array('controller' => 'Admin\Controller\Utenti', 'action' => 'elimina', 'roles' => array('super-amministratore', 'amministratore')),

                //Controller ProgrammaModalita
                array('controller' => 'Admin\Controller\ProgrammaModalita', 'roles' => array('super-amministratore', 'amministratore')),

            ),
        )
    ),
);
