SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

--
-- Database: `eliminacode`
--

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_accettazione`
--

CREATE TABLE IF NOT EXISTS `ec_accettazione` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_totem` int(11) NOT NULL,
  `id_sportello` int(11) NOT NULL,
  `id_prenotazione` int(11) NOT NULL,
  `id_operatore` int(11) NOT NULL,
  `id_prestazione` int(11) NOT NULL,
  `data_inserimento` date NOT NULL,
  `ora_accettazione` time NOT NULL,
  `nome_utente` varchar(45) NOT NULL,
  `cognome_utente` varchar(45) NOT NULL,
  `codice_fiscale` varchar(16) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_agenda_servizi`
--

CREATE TABLE IF NOT EXISTS `ec_agenda_servizi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(100) NOT NULL,
  `status` int(11) NOT NULL,
  `data_inizio` datetime NOT NULL,
  `data_fine` datetime NOT NULL,
  `id_medico` int(11) NOT NULL,
  `modalita` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_display`
--

CREATE TABLE IF NOT EXISTS `ec_display` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `logo` varchar(100) NOT NULL,
  `info` text NOT NULL,
  `organigramma` text NOT NULL,
  `id_meteo` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_feed`
--

CREATE TABLE IF NOT EXISTS `ec_feed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titolo` varchar(255) NOT NULL,
  `intervallo` int(11) NOT NULL,
  `url` varchar(255) NOT NULL,
  `categoria` varchar(255) NOT NULL,
  `blocco_entrata` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_immagini`
--

CREATE TABLE IF NOT EXISTS `ec_immagini` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titolo` varchar(255) NOT NULL,
  `descrizione` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_news`
--

CREATE TABLE IF NOT EXISTS `ec_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titolo` varchar(255) NOT NULL,
  `descrizione` text NOT NULL,
  `immagine` varchar(255) NOT NULL,
  `data` date NOT NULL,
  `ora` time NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_prenotazioni`
--

CREATE TABLE IF NOT EXISTS `ec_prenotazioni` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(45) NOT NULL,
  `cognome` varchar(45) NOT NULL,
  `codice_fiscale` varchar(16) NOT NULL,
  `data` date NOT NULL,
  `ora` time NOT NULL,
  `approvato` varchar(36) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_prestazione_ambulatorio`
--

CREATE TABLE IF NOT EXISTS `ec_prestazione_ambulatorio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_accettazione` int(11) NOT NULL,
  `id_infermiere` int(11) NOT NULL,
  `id_operatore` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `data` date NOT NULL,
  `inizio_prestazione` time NOT NULL,
  `fine_prestazione` time NOT NULL,
  `ora_presa_carico` time NOT NULL,
  `modalita` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_prestazione_day_hospital`
--

CREATE TABLE IF NOT EXISTS `ec_prestazione_day_hospital` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_accettazione` int(11) NOT NULL,
  `id_infermiere` int(11) NOT NULL,
  `id_medico` int(11) NOT NULL,
  `data` date NOT NULL,
  `inizio_prelievo` time NOT NULL,
  `fine_prelievo` time NOT NULL,
  `gruppo` varchar(35) NOT NULL,
  `prestazione_inizio` time NOT NULL,
  `prestazione_fine` time NOT NULL,
  `ora_presa_carico` time NOT NULL,
  `modalita` varchar(50) NOT NULL,
  `stato_prelievo` varchar(50) NOT NULL,
  `stato_prestazione` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_prestazione_ricovero`
--

CREATE TABLE IF NOT EXISTS `ec_prestazione_ricovero` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_accettazione` int(11) NOT NULL,
  `id_infermiere` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `data` date NOT NULL,
  `prestazione_inizio` time NOT NULL,
  `prestazione_fine` time NOT NULL,
  `ora_presa_carico` time NOT NULL,
  `modalita` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_programma_agenda`
--

CREATE TABLE IF NOT EXISTS `ec_programma_agenda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `giorno` varchar(35) NOT NULL,
  `am_inizio` time NOT NULL,
  `am_fine` time NOT NULL,
  `am_freq` int(11) NOT NULL,
  `pm_inizio` time NOT NULL,
  `pm_fine` time NOT NULL,
  `pm_freq` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_programma_modalita`
--

CREATE TABLE IF NOT EXISTS `ec_programma_modalita` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_utente` int(11) NOT NULL,
  `id_modalita` int(11) NOT NULL,
  `data_inizio` datetime NOT NULL,
  `data_fine` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_ruoli`
--

CREATE TABLE IF NOT EXISTS `ec_ruoli` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ruolo` varchar(30) NOT NULL,
  `parent_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


-- --------------------------------------------------------

--
-- Struttura della tabella `ec_servizi`
--

CREATE TABLE IF NOT EXISTS `ec_servizi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) NOT NULL,
  `descrizione` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_modalita`
--

CREATE TABLE IF NOT EXISTS `ec_modalita` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codice` varchar(50) NOT NULL,
  `nome` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_status`
--

CREATE TABLE IF NOT EXISTS `ec_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome_status` varchar(35) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_ticket_totem`
--

CREATE TABLE IF NOT EXISTS `ec_ticket_totem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_servizio` int(11) NOT NULL,
  `id_utente` int(11) NOT NULL,
  `id_sportello` int(11) NOT NULL,
  `data` datetime NOT NULL,
  `codice_ticket` varchar(36) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_tracking_prestazione`
--

CREATE TABLE IF NOT EXISTS `ec_tracking_prestazione` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_prestazione` int(11) NOT NULL,
  `id_operatore` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `data` date NOT NULL,
  `ore` time NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_tracking_sportello`
--

CREATE TABLE IF NOT EXISTS `ec_tracking_sportello` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_sportello` int(11) NOT NULL,
  `id_programma_sportello` int(11) NOT NULL,
  `id_operatore` int(11) NOT NULL,
  `id_agenda_servizio` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `data` date NOT NULL,
  `ora` time NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_tracking_ticket`
--

CREATE TABLE IF NOT EXISTS `ec_tracking_ticket` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ticket` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `data` date NOT NULL,
  `ora` time NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_utenti`
--

CREATE TABLE IF NOT EXISTS `ec_utenti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ruolo` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `username` varchar(45) NOT NULL,
  `password` varchar(255) NOT NULL,
  `nome` varchar(45) NOT NULL,
  `cognome` varchar(45) NOT NULL,
  `codice_fiscale` varchar(16) NOT NULL,
  `email` varchar(60) NOT NULL,
  `cap` varchar(5) NOT NULL,
  `citta` varchar(45) NOT NULL,
  `indirizzo` varchar(45) NOT NULL,
  `telefono` varchar(12) NOT NULL,
  `cellulare` varchar(12) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `ec_video`
--

CREATE TABLE IF NOT EXISTS `ec_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titolo` varchar(255) NOT NULL,
  `descrizione` text NOT NULL,
  `orario` time NOT NULL,
  `tipologia` varchar(36) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;